/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable;

import dev.compactmods.crafting.lib.reactivestreams.Publisher;
import dev.compactmods.crafting.lib.reactivestreams.Subscriber;
import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Flowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.FlowableSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowableDelaySubscriptionOther<T, U>
extends Flowable<T> {
    final Publisher<? extends T> main;
    final Publisher<U> other;

    public FlowableDelaySubscriptionOther(Publisher<? extends T> main, Publisher<U> other) {
        this.main = main;
        this.other = other;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> child) {
        MainSubscriber<? extends T> parent = new MainSubscriber<T>(child, this.main);
        child.onSubscribe(parent);
        this.other.subscribe(parent.other);
    }

    static final class MainSubscriber<T>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 2259811067697317255L;
        final Subscriber<? super T> downstream;
        final Publisher<? extends T> main;
        final OtherSubscriber other;
        final AtomicReference<Subscription> upstream;

        MainSubscriber(Subscriber<? super T> downstream, Publisher<? extends T> main) {
            this.downstream = downstream;
            this.main = main;
            this.other = new OtherSubscriber();
            this.upstream = new AtomicReference();
        }

        void next() {
            this.main.subscribe(this);
        }

        @Override
        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                SubscriptionHelper.deferredRequest(this.upstream, this, n);
            }
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.other);
            SubscriptionHelper.cancel(this.upstream);
        }

        @Override
        public void onSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this, s);
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<Object> {
            private static final long serialVersionUID = -3892798459447644106L;

            OtherSubscriber() {
            }

            @Override
            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce(this, s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            @Override
            public void onNext(Object t) {
                Subscription s = (Subscription)this.get();
                if (s != SubscriptionHelper.CANCELLED) {
                    this.lazySet(SubscriptionHelper.CANCELLED);
                    s.cancel();
                    MainSubscriber.this.next();
                }
            }

            @Override
            public void onError(Throwable t) {
                Subscription s = (Subscription)this.get();
                if (s != SubscriptionHelper.CANCELLED) {
                    MainSubscriber.this.downstream.onError(t);
                } else {
                    RxJavaPlugins.onError(t);
                }
            }

            @Override
            public void onComplete() {
                Subscription s = (Subscription)this.get();
                if (s != SubscriptionHelper.CANCELLED) {
                    MainSubscriber.this.next();
                }
            }
        }
    }
}

